$(document).ready(function()
{
	user.show_main_view_intreface()
    user.show_errors_info()

    const ota_settings_script = utils.load_script('ota_settings.js')
    const app_sw_script = utils.load_script('app_sw.js')
    const device_info_script = utils.load_script('device_info.js')
    const one_wire_script = utils.load_script('one_wire.js')
    Promise.all([
        ota_settings_script,
        app_sw_script,
        one_wire_script,
        device_info_script
    ])
	.then(() => app_sw.main())
    .then(() => device_info.show())
    .then(() => one_wire.get_sensors_data())
	.then(data => one_wire.show(data.ids, data.sensors_count))
	.then(() => {
        ota_settings.show()
        user.on_page_loading_finished()
        user.load_page()
	})
})
